# Copyright (C) 1999 Lucent Technologies
# Kod z ksiazki The Practice of Programming
# Briana W. Kernighana i Roba Pike'a

# markov.awk: algorytm łańcucha Markowa dla przedrostków dwuwyrazowych
BEGIN {	MAXGEN = 10000; NONWORD = "\n"; w1 = w2 = NONWORD }

{	for (i = 1; i <= NF; i++) { 	# Wczytanie wszystkich słów
		statetab[w1,w2,++nsuffix[w1,w2]] = $i
		w1 = w2
		w2 = $i
	}
}

END {
	statetab[w1,w2,++nsuffix[w1,w2]] = NONWORD	# Dodanie ogona
	w1 = w2 = NONWORD
	for (i = 0; i < MAXGEN; i++) {	# Generowanie
		r = int(rand()*nsuffix[w1,w2]) + 1  # nsuffix >= 1
		p = statetab[w1,w2,r]
		if (p == NONWORD)
			exit
		print p
		w1 = w2			# Aktualizacja łańcucha
		w2 = p
	}
}
